<?php defined('BASEPATH') or exit('No direct script access allowed');

class Ativity_model extends CI_Model
{




    public function get($id = null)
    {

        $this->db->from('tb_ativity');

        if ($id != null) {
            $this->db->where('id', $id);
        }

        return $this->db->get();
    }

    public function get_atividades_by_municipio($id)
    {

        $this->db->from('tb_ativity');
        $this->db->join('tb_categoria_atividade', 'tb_categoria_atividade.id_categoria = tb_ativity.categoria_id');

        if ($id != null) {
            $this->db->where('municipio_id', $id);
        }

        return $this->db->get();

    }

    public function getOrcamentoPeople()
    {

        $this->db->select('COUNT(*) as total_atividade, SUM(orcamento) as total_orcamento, SUM(beneficiario) as total_people, AVG(progresso) as media');
        $this->db->from('tb_ativity');

        return $this->db->get()->result();
    }
    public function getMunicipios($id = null)
    {
        $this->db->from('tb_municipios');

        if ($id != null) {
            $this->db->where('id_municipio', $id);
        }
        $this->db->order_by('status_muni', 'asc');
        return $this->db->get();
    }

    public function getOrcamentoByMunicipio($id)
    {

        $this->db->select('COUNT(*) as total_atividade, SUM(orcamento) as total_orcamento, SUM(beneficiario) as total_people, AVG(progresso) as media');
        $this->db->from('tb_ativity');
        $this->db->where('municipio_id', $id);

        return $this->db->get()->row();
    }



    public function get_project_details($id)
    {

        $this->db->select('id, municipio_id as municipalityId, titulo_atividade as title, objectivo_geral as description, localizacao as location,
    data_inicio as startDate, data_fim as endDate, orcamento as budget, gasto_orcamento as spent, progresso as progress, status, descricao as category,
    objectivo_especifico as objective, beneficiario as beneficiaries, responsavel as contractor  ');
        $this->db->from('tb_ativity');
        $this->db->join('tb_categoria_atividade', 'tb_categoria_atividade.id_categoria = tb_ativity.categoria_id');
        $this->db->where('id', $id);
        $project = $this->db->get()->row_array();

        if (empty($project)) {
            return null;
        }


        $this->db->select('create_at  as date, descricao as description, progresso as percentage');
        $this->db->where('atividade_id', $id);
        $this->db->order_by('create_at', 'DESC');
        $updates = $this->db->get('tb_progress_ativity')->result_array();

        $this->db->select('anexo as images');
        $this->db->where('atividade_id', $id);
        $this->db->where('anexo IS NOT NULL');
        $this->db->group_by('anexo');
        $images_result = $this->db->get('tb_progress_ativity')->result_array();

        $images = array();
        foreach ($images_result as $row) {
            if (!empty($row['images'])) {
                $images[] = 'http://localhost/sigeat/upload/'.$row['images'];
            }
        }



        $project['details'] = array(
            'objective' => $project['objective'],
            'beneficiaries' => $project['beneficiaries'],
            'contractor' => $project['contractor'],
            'images' => $images,
            'updates' => $updates
        );

        unset($project['objective'], $project['beneficiaries'], $project['contractor']);

        //$project['progress'] = $project['progress']; 



        return $project;
    }


	public function insert_problem($data = array()){
		if($data){
			$insert = $this->db->insert('tb_report_problem',$data);
			return ($insert == true) ? true : false;
		}
	}

    	public function insert_requestinfo($data = array()){
		if($data){
			$insert = $this->db->insert('tb_requestinfo',$data);
			return ($insert == true) ? true : false;
		}
	}








}