<?php
defined('BASEPATH') or exit('No direct script access allowed');
//require './vendor/autoload.php';

require APPPATH . 'libraries/RestController.php';

use chriskacerguis\RestServer\RestController;

class Home extends RestController
{

    function __construct()
    {
        parent::__construct();

        $this->load->model(['Ativity_model']);
        $this->load->library('form_validation');
        $this->load->helper('url', 'form');
    }

    public function index_get()
    {
        echo "Sou API REST ";
    }




    public function count_ativity_get()
    {
        $ativity = new Ativity_model;
        $result = $ativity->getOrcamentoPeople();
        $this->response($result, 200);
    }

    public function list_municipio_get()
    {
        $ativity = new Ativity_model;
        $query = $ativity->getMunicipios();

        $municipios = array();

        if ($query->num_rows() > 0) {

            foreach ($query->result() as $municipio) {
                $row = $ativity->getOrcamentoByMunicipio($municipio->id_municipio);
                $nome = $municipio->nome_municipio;
                $municipios[] = array(
                    'id' => $municipio->id_municipio,
                    'name' => $nome,
                    'activities' => $row->total_atividade ?? 0,
                    'budget' => $row->total_orcamento ?? 0,
                    'completion' => $row->media * 100 ?? 0,
                    'population' => $municipio->population,
                    'area' => $municipio->area
                );
            }

            $this->response($municipios, 200);

        } else {
            $this->response([

                'message' => 'Dados nao encontrado',
            ], 200);
        }


    }

    public function municipio_get($id)
    {
        $ativity = new Ativity_model;
        $query = $ativity->getMunicipios($id);

        $municipios = array();

        if ($query->num_rows() > 0) {

            $municipio = $query->row();
            $row = $ativity->getOrcamentoByMunicipio($municipio->id_municipio);
            $nome = $municipio->nome_municipio;
            $municipios = array(
                'id' => $municipio->id_municipio,
                'name' => $nome,
                'activities' => $row->total_atividade ?? 0,
                'budget' => $row->total_orcamento ?? 0,
                'completion' => $row->media * 100 ?? 0,
                'population' => $municipio->population,
                'area' => $municipio->area
            );


            $this->response($municipios, 200);

        } else {
            $this->response([

                'message' => 'Dados nao encontrado',
            ], 200);
        }


    }

    public function municipios_get($id = null, $sub = null)
    {
        if ($sub === 'atividades' && $id !== null) {
            $ativity = new Ativity_model;
            $query = $ativity->get_atividades_by_municipio($id);

            $municipios = array();

            if ($query->num_rows() > 0) {

                foreach ($query->result() as $row) {

                    if ($row->status == 1) {
                        $status = 'planejado';
                    } elseif ($row->status == 2) {
                        $status = 'em_andamento';
                    } elseif ($row->status == 3) {
                        $status = 'concluido';
                    } elseif ($row->status == 2) {
                        $status = 'atrasado';
                    }

                    $municipios[] = array(
                        'id' => $row->id,
                        'municipalityId' => $row->municipio_id,
                        'title' => $row->titulo_atividade,
                        'descpription' => $row->objectivo_geral,
                        'location' => $row->localizacao,
                        'startDate' => $row->data_inicio,
                        'endDate' => $row->data_fim,
                        'budget' => $row->orcamento,
                        'spent' => $row->gasto_orcamento,
                        'progress' => $row->progresso * 100,
                        'status' => $status,
                        'category' => $row->descricao
                    );
                }

                $this->response($municipios, 200);

            } else {

                $this->response([
                    'message' => 'Dados não encontrado',
                ], 401);
            }
        } else {

            $this->response([
                'message' => 'Requisição invalida',
            ], 401);

        }
    }

    public function list_atividade_get($id)
    {
        $ativity = new Ativity_model;
        $result = $ativity->get_project_details($id);
        $this->response($result, 200);
    }

    public function create_report_problem_put()
{
    $ativity = new Ativity_model;

    try {
        $this->form_validation->set_data($this->put());

        $this->form_validation->set_rules('name', 'nome', 'trim|required');
        $this->form_validation->set_rules('urgency', 'nível de urgência', 'trim|required');
        $this->form_validation->set_rules('description', 'descrição', 'trim|required');

        $this->form_validation->set_message('required', 'O campo %s é obrigatório, por favor preencha!');

        if (!$this->form_validation->run()) {
            // Envia resposta de erro sem continuar com o insert
            $this->response([
                'status' => false,
                'message' => strip_tags(validation_errors()),
            ], RestController::HTTP_BAD_REQUEST);
            return;
        }

        // Validação passou, então coleta os dados
        $data = array(
            'nome'           => $this->put('name'),
            'ativity_id'     => $this->put('ativity_id'),
            'tell'           => $this->put('tell'),
            'email'          => $this->put('email'),
            'nivel_urgencia' => $this->put('urgency'),
            'descricao'      => $this->put('description')
        );

        $create = $ativity->insert_problem($data);

        if ($create) {
            $this->response([
                'status' => true,
                'message' => 'Cadastro efetuado com sucesso',
            ], RestController::HTTP_OK);
        } else {
            $this->response([
                'status' => false,
                'message' => 'Falha ao cadastrar',
            ], RestController::HTTP_INTERNAL_SERVER_ERROR);
        }

    } catch (\Throwable $e) {
        $this->response([
            'status' => false,
            'message' => $e->getMessage(),
        ], RestController::HTTP_INTERNAL_SERVER_ERROR);
    }
}

    public function create_requestinfo_put()
{
    $ativity = new Ativity_model;

    try {
        $this->form_validation->set_data($this->put());

        $this->form_validation->set_rules('name', 'nome', 'trim|required');
        $this->form_validation->set_rules('municipality', 'email', 'trim|required');
        $this->form_validation->set_rules('subject', 'Assunto', 'trim|required');
        $this->form_validation->set_rules('description', 'descrição', 'trim|required');

        $this->form_validation->set_message('required', 'O campo %s é obrigatório, por favor preencha!');

        if (!$this->form_validation->run()) {
            // Envia resposta de erro sem continuar com o insert
            $this->response([
                'status' => false,
                'message' => strip_tags(validation_errors()),
            ], RestController::HTTP_BAD_REQUEST);
            return;
        }

        // Validação passou, então coleta os dados
        $data = array(
            'name'           => $this->put('name'),
            'municipality'     => $this->put('municipality'),
            'phone'           => $this->put('phone'),
            'email'          => $this->put('email'),
            'infoType' => $this->put('infoType'),
            'subject'      => $this->put('subject'),
            'description'      => $this->put('description')
        );

        $create = $ativity->insert_requestinfo($data);

        if ($create) {
            $this->response([
                'status' => true,
                'message' => 'Cadastro efetuado com sucesso',
            ], RestController::HTTP_OK);
        } else {
            $this->response([
                'status' => false,
                'message' => 'Falha ao cadastrar',
            ], RestController::HTTP_INTERNAL_SERVER_ERROR);
        }

    } catch (\Throwable $e) {
        $this->response([
            'status' => false,
            'message' => $e->getMessage(),
        ], RestController::HTTP_INTERNAL_SERVER_ERROR);
    }
}



    

}
